<?php

/*
 * This file is part of Contao.
 *
 * Copyright (c) 2005-2018 Leo Feyer
 *
 * @license LGPL-3.0+
 */

namespace Contao\CoreBundle\Tests\DependencyInjection\Compiler;

use Contao\CoreBundle\DependencyInjection\Compiler\AddImagineClassPass;
use Contao\CoreBundle\Tests\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;

/**
 * Tests the AddImagineClassPass class.
 *
 * @author Leo Feyer <http://github.com/leofeyer>
 */
class AddImagineClassPassTest extends TestCase
{
    /**
     * Tests the object instantiation.
     */
    public function testCanBeInstantiated()
    {
        $pass = new AddImagineClassPass();

        $this->assertInstanceOf('Contao\CoreBundle\DependencyInjection\Compiler\AddImagineClassPass', $pass);
    }

    /**
     * Tests adding the Imagine class.
     */
    public function testAddsTheImagineClass()
    {
        $container = new ContainerBuilder();
        $container->setDefinition('contao.image.imagine', new Definition());

        $pass = new AddImagineClassPass();
        $pass->process($container);

        $this->assertContains(
            $container->getDefinition('contao.image.imagine')->getClass(),
            [
                'Imagine\Gd\Imagine',
                'Imagine\Gmagick\Imagine',
                'Imagine\Imagick\Imagine',
            ]
        );
    }
}
